/*------------------------------------------------------------------------------*
 * File Name: QuickFit.h	 													*
 * Creation: 																	*
 * Purpose: OriginC Header H file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
 *	Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
 *	Folger 01/14/09 QA81-14832 SUPPORT_QUICK_FIT_THEME_WITH_PREFERENCE_SETTINGS	*
 *	Sophy 1/18/2010 QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS				*
 *	Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT				*
 *	CPY 1/20/10 QUICK_FIT_FAILED_COMPILE_WITHOUT_DEVKIT							*
 *	Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI					*
 *	Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST							*
 *  Iris 1/25/2010 TO_FIX_CLICK_OUTPUT_BUTTON_ALWAYS_DO_FINDXY					* 
 *	Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB		*
 *	Sophy 1/29/2010 QA80-14995-P2 CHECK_UPDATE_REPORT_WORKSHEET_NAME_FOR_ROI_TOOLS
 *	Folger 02/03/10 ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG					*
 *	Kenny 02/04/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI		*
 *	Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU				*
 *	Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE									*
 *	Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU						*
 *	Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX*
 *	Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT						*
 *	Kenny 03/04/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR	*
 *	Folger 04/09/10 UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
 *	Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
 *------------------------------------------------------------------------------*/
#ifndef _QUICK_FIT_H
#define _QUICK_FIT_H

 
#include "DialogEx.h"
/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG, already define in oc_sys.h
/*
#define STR_LINE_FUNCTION						_L("Line")
#define STR_QUADRATIC_FUNCTION					_L("Quadratic")
#define STR_CUBIC_FUNCTION						_L("Cubic")
*/
///End NEW_QUICKFIT_ROI_XF_DLG

#define STR_FORCE_APPLY_ROI_X_POS_ATTRIB		"ForceApplyXPos"

/// Kenny 02/05/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
#define QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI	// For dev. procedure only, just in case potential bug
/// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI

/// Iris 1/22/2010 KEEP_FIRST_3_POLY_FUNC_WITH_REAL_NAME
#define		POLY_LINEAR_FIT_FUNC_NAME			_OL("Linear")
#define		POLY_QUADRATIC_FIT_FUNC_NAME		_OL("Quadratic")
#define		POLY_CUBIC_FIT_FUNC_NAME			_OL("Cubic")
#define	 	NUM_FIXED_POLY_FUNC					3// Line, Quadratic, Cubie
///End KEEP_FIRST_3_POLY_FUNC_WITH_REAL_NAME

/// Iris 1/21/2010 USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR
#define 	NUM_POLY_FUNC_MIN_ORDER		1
#define	 	NUM_POLY_FUNC_MAX_ORDER		7
///End USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR

///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
#define		STR_R_SQR				_L("R-Square")
#define		STR_PEARSON_R			_L("Pearson's r")
///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

/// Kenny 02/04/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
#define		STR_SHOW_TOP_ADJ_R_SQUARE	_L("Adj. R-Square")
#define		STR_SHOW_TOP_PARAMETERS		_L("Parameters")
#define		STR_SHOW_TOP_NONE			_L("None")
#define		STR_SHOW_TOP_REDUCE_CHISQ	_L("Reduced Chi-Sqr")
/// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI

///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
//#define	STR_UPDATE_FUNCTION_LIST	_L("Edit Quick Fit Function List...")
#define	STR_UPDATE_FUNCTION_LIST	STR_MORE
///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
///////////////Output Reference Dialog////////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////

#define WM_USER_ON_ROI_GETN_CHANGE		(WM_USER + 1020)

///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
class GridCheckListCtrl;
///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST

class QuickFitOutputReferDlg : public ResizeDialog
{
public:	
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
	//QuickFitOutputReferDlg(bool bROIUsed = false, int nOrder = 0, LPCSTR lpcszFunc = NULL);
	QuickFitOutputReferDlg(TreeNode& trSettings);
	///End NEW_QUICKFIT_ROI_XF_DLG
	int DoModalEx(HWND hWndParent = NULL);
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_SIZE(OnDlgResize)
	ON_RESTORESIZE(OnRestoreSize)
	ON_DESTROY(OnDestroy)
	
	ON_OK(OnOK)
	ON_BN_CLICKED(IDC_APPLY, OnApply)
	ON_TAB_SEL_CHANGE(IDC_QUICKFIT_PREFERENCE_TAB, OnTabChange)

	// Output
	ON_BN_CLICKED(IDC_OUTPUT_TO_NONE, OnOutputResultToChange)
	ON_BN_CLICKED(IDC_OUTPUT_TO_SCRIPT_WINDOW, OnOutputResultToChange)
	ON_BN_CLICKED(IDC_OUTPUT_TO_RESULT_LOG, OnOutputResultToChange)
	ON_BN_CLICKED(IDC_OUTPUT_TO_WKS, OnOutputResultToChange)	
	
	//X Data Type
	///Sophy 3/1/2010 UPDATE_FITCURVE_SETTINGS_IN_QUICKFIT_PREFERENCE_DLG
	ON_BN_CLICKED(IDC_FIT_CURVE_SAME_AS_SOURCE_DATA, OnXDataTypeChange)
	ON_BN_CLICKED(IDC_FIT_CURVE_SAME_AS_SOURCE_SCALE, OnXDataTypeChange)	
	ON_BN_CLICKED(IDC_FIT_CURVE_UNIFORM_LINEAR, OnXDataTypeChange)
	///end UPDATE_FITCURVE_SETTINGS_IN_QUICKFIT_PREFERENCE_DLG
	

	
	// Table
	ON_BN_CLICKED(IDC_CHECK_ADD_LABEL, OnAddTableToGraphSelChange)
	ON_CBN_SELCHANGE(IDC_COMBO_EQUATION_FORMAT, OnEquationFormatChange)
	ON_CBN_SELCHANGE(IDC_COMBO_SIGNIFICANT_DIGITS, OnSignDigitsChange)
	ON_BN_CLICKED(IDC_CHECK_FUNCTION, OnCheckFunction)
	ON_BN_CLICKED(IDC_CHECK_INPUT, OnCheckInput)
	ON_BN_CLICKED(IDC_CHECK_OUTPUT, OnCheckOutput)
	ON_CBN_SELCHANGE(IDC_COMBO_PARAMS, OnParamTableChange)
	ON_BN_CLICKED(IDC_CHECK_SHOW_ERROR, OnShowErrorChange)		///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	///Sophy 1/23/2010 SET_DIRTYBIT_FOR_SHOW_TOOLNAME_EVENT
	ON_BN_CLICKED(IDC_CHECK_ROI_SHOW_TOOL_NAME, OnShowToolName)
	ON_EN_CHANGE(IDC_EDIT_TOOL_NAME, OnToolNameChange)
	///end SET_DIRTYBIT_FOR_SHOW_TOOLNAME_EVENT
	ON_BN_CLICKED(IDC_CHECK_CLONE_MAINOBJ, OnCheckCloneMainObj)	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	///Sophy 1/29/2010 QA80-14995-P2 CHECK_UPDATE_REPORT_WORKSHEET_NAME_FOR_ROI_TOOLS
	ON_KEY(IDC_EDIT_WKS_NAME, OnAfterReportWksChange)
	ON_EN_KILLFOCUS(IDC_EDIT_WKS_NAME, OnReportWksNameChange)
	///end CHECK_UPDATE_REPORT_WORKSHEET_NAME_FOR_ROI_TOOLS
	ON_BN_CLICKED(IDC_FIT_STATS_RSQCOD, OnCheckRSQCOD)
	ON_BN_CLICKED(IDC_FIT_STATS_ADJRSQ, OnCheckADJRSQ)
	///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	ON_BN_CLICKED(IDC_FIT_STATS_RSQUARE, OnCheckRSQuare)
	ON_BN_CLICKED(IDC_FIT_STATS_PEARSON_R, OnCheckCorrelation)
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	ON_BN_CLICKED(IDC_FIT_STATS_NUM_ITER, OnCheckNumIter)
	ON_BN_CLICKED(IDC_FIT_STATS_FIT_STATUS, OnCheckFitStatus)
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	// ROI
	/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
	ON_EN_CHANGE(IDC_EDIT_ROI_LEFT_X, OnROIXPositionChange)
	ON_EN_CHANGE(IDC_EDIT_ROI_RIGHT_X, OnROIXPositionChange)
	///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	ON_BN_CLICKED(IDC_CHECK_XSCALE_FIX, OnXScaleFixChange) /// Iris 2/21/2010 ADD_AUTO_CHOICE_FOR_FIT_LINE_COLOR
	ON_CBN_SELCHANGE(IDC_COMBO_ROI_SIGNIFICANT_DIGITS, OnROISignDigitsChange)
	///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	//ON_BN_CLICKED(IDC_RADIO_ROI_NONE, OnROITopInfoChange)
	//ON_BN_CLICKED(IDC_RADIO_ROI_REDUCED_CHISQ, OnROITopInfoChange)
	//ON_BN_CLICKED(IDC_RADIO_ROI_ADJ_R_SQR, OnROITopInfoChange)
	//ON_BN_CLICKED(IDC_RADIO_ROI_PARAM, OnROITopInfoChange)
	///// Kenny 02/08/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
//#ifdef QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
	//ON_BN_CLICKED(IDC_RADIO_ROI_R_SQUARE, OnROITopInfoChange)
	//ON_BN_CLICKED(IDC_RADIO_ROI_PEARSONS_R, OnROITopInfoChange)
//#endif // QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
	///// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	ON_BN_CLICKED(IDC_CHECK_ROI_REDUCED_CHISQ, OnROITopInfoChange)
	ON_BN_CLICKED(IDC_CHECK_ROI_ADJ_R_SQR, OnROITopInfoChange)
	ON_BN_CLICKED(IDC_CHECK_ROI_R_SQUARE, OnROITopInfoChange)
	ON_BN_CLICKED(IDC_CHECK_ROI_PEARSONS_R, OnROITopInfoChange)
	///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	/// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
	//ON_CBN_EDITCHANGE(IDC_COMBO_ROI_PARAM_INDEX, OnROITopInfoParamIndexChange)
	//ON_CBN_SELCHANGE(IDC_COMBO_ROI_PARAM_INDEX, OnROITopInfoParamIndexChange)
	///End SHOW_ALL_PARAMS_ON_ROI_TOP
	///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	ON_GRID_BEFORE_EDIT(IDC_GRID_PARAM_LIST, OnBeforeEditParamListControl)
	ON_GRID_AFTER_EDIT(IDC_GRID_PARAM_LIST, OnAfterEditParamListControl)
	///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	ON_USER_MSG(WM_USER_ON_ROI_GETN_CHANGE, OnROIGetNChange)

	/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	/////------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
	//ON_BN_CLICKED(IDC_XSCALE_AUTO_FROM, OnCheckAutoXScaleFrom)
	//ON_BN_CLICKED(IDC_XSCALE_AUTO_TO, OnCheckAutoXScaleTo)
	/////------ End SUPPORT_AUTO_FOR_X_SCALE
	///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	ON_CBN_SELCHANGE(IDC_CHECK_INPUT, onSharedControlChange)
	ON_CBN_SELCHANGE(IDC_CHECK_INPUT_RANGE_INDEX, onSharedControlChange)
	ON_CBN_SELCHANGE(IDC_CHECK_OUTPUT, onSharedControlChange)
	ON_BN_CLICKED(IDC_CHECK_FITTED_CURVE_LEGEND, onSharedControlChange)
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
	
EVENTS_END

	BOOL OnInitDialog();	
	BOOL OnDlgResize(int nType, int cx, int cy);	
	BOOL OnRestoreSize(DWORD dwSizeInfo);	
	BOOL OnDestroy();
	BOOL OnOK();
	BOOL OnApply(Control ctrl);

	BOOL OnTabChange(Control ctrl);

	// Output
	BOOL OnOutputResultToChange(Control ctrl);
	
	//X Data Type
	///Sophy 3/1/2010 UPDATE_FITCURVE_SETTINGS_IN_QUICKFIT_PREFERENCE_DLG
	BOOL OnXDataTypeChange(Control ctrl);
	///end UPDATE_FITCURVE_SETTINGS_IN_QUICKFIT_PREFERENCE_DLG
	
	// Table
	BOOL OnAddTableToGraphSelChange(Control ctrl);
	BOOL OnEquationFormatChange(Control ctrl);
	BOOL OnSignDigitsChange(Control ctrl);
	BOOL OnParamTableChange(Control ctrl);
	BOOL OnShowErrorChange(Control ctrl);	///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	BOOL OnCheckFunction(Control ctrl);
	BOOL OnCheckInput(Control ctrl);
	BOOL OnCheckOutput(Control ctrl);
	BOOL OnCheckRSQCOD(Control ctrl);
	BOOL OnCheckADJRSQ(Control ctrl);
	///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	BOOL OnCheckRSQuare(Control ctrl);
	BOOL OnCheckCorrelation(Control ctrl);
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	BOOL	OnCheckNumIter(Control ctrl);
	BOOL	OnCheckFitStatus(Control ctrl);
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	
	///Sophy 1/23/2010 SET_DIRTYBIT_FOR_SHOW_TOOLNAME_EVENT
	BOOL OnShowToolName(Control ctrl);
	BOOL OnToolNameChange(Control ctrl);
	///end SET_DIRTYBIT_FOR_SHOW_TOOLNAME_EVENT
	BOOL OnCheckCloneMainObj(Control ctrl);	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	///Sophy 1/29/2010 QA80-14995-P2 CHECK_UPDATE_REPORT_WORKSHEET_NAME_FOR_ROI_TOOLS
	BOOL OnAfterReportWksChange(Control ctrl, UINT nMsg, UINT wParam, UINT lParam);
	BOOL OnReportWksNameChange(Control ctrl);
	///end CHECK_UPDATE_REPORT_WORKSHEET_NAME_FOR_ROI_TOOLS

	// ROI
	BOOL OnROIXPositionChange(Control ctrl);  /// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
	BOOL OnXScaleFixChange(Control ctrl); /// Iris 2/21/2010 ADD_AUTO_CHOICE_FOR_FIT_LINE_COLOR
	BOOL OnROISignDigitsChange(Control ctrl);
	BOOL OnROITopInfoChange(Control ctrl);
	/// Iris 1/07/2010 SHOW_ALL_PARAMS_ON_ROI_TOP
	//BOOL OnROITopInfoParamIndexChange(Control ctrl);
	///End SHOW_ALL_PARAMS_ON_ROI_TOP
	///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	void OnBeforeEditParamListControl(Control flxControl, long nRow, long nCol, BOOL* pCancel);
	void OnAfterEditParamListControl(Control flxControl, int nRow, int nCol);
	///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	void OnROIGetNChange(uint wParam, uint lParam = 0);

	/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	/////------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
	//BOOL	OnCheckAutoXScaleFrom(Control cntrl);
	//BOOL	OnCheckAutoXScaleTo(Control cntrl);
	/////------ End SUPPORT_AUTO_FOR_X_SCALE
	///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX

	void SaveSettings();
	void LoadSettings();

public:
	TreeNode GetSettings();
	//--- CPY 1/20/10 QUICK_FIT_FAILED_COMPILE_WITHOUT_DEVKIT, should not use inline in dialog file if needed to be included in xf
	// also, this maybe no longer needed?
	//BOOL SaveTheme(){ Control cc; return OnSaveAs(cc); }
	//---
	
	
private:
	void initControls();
	void initControlPos();
	void initControlValues();
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	void initSharedControlValues(); 
	void updateSharedSettings(int nTab = -1); // if nTab is -1, get currect tab index inside function.
	TreeNode getBranchNodeByTab(int nTab = -1);
	///End REARRANGE_PREFERENCE_DLG_TABS
	bool getSourceFromTo(double* pdFrom = NULL, double* pdTo = NULL, int* pnNumPoints = NULL);

	bool onSharedControlChange(Control ctrl);
	//----- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED
	//void updateSharedControlPos(int n1stGroupLastControl, int nCurrentTab, int nXOffset, int nGap); /// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	void moveControlsToTab(int nGap, int nTab, const RECT& rBounds);
	//-----
	int getCtrlIDs(vector<uint>& vnIDs, int nTab, bool bSharedControls = false);

	BOOL showHideControls(int nTab, bool bShow);
	void moveCtrlOffset(const vector<uint>& vnIDs, int nXOffset, int nYOffset);
	BOOL resizeDlgToFitControls(int nTab);

	/// Kenny 02/05/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
//	BOOL showHideROIControls(int nTab);//---- CPY 2/19/10 QUICK_FIT_PREF_DLG_OUTPUT_REORGANIZED comment out
	/// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	
	void convertTableSettingsFromDlgToThemeTree(TreeNode& trTableTheme);
	/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	//void convertOutputSettingsFromDlgToThemeTree(TreeNode& trTableTheme);
	void convertOutputChoiceFromDlgToThemeTree(TreeNode& tr);
	void convertReportSettingsFromDlgToThemeTree(TreeNode& tr);
	void convertFitCurveSettingsFromDlgToThemeTree(TreeNode& tr);
	///End REARRANGE_PREFERENCE_DLG_TABS
	void convertROISettingsFromDlgToThemeTree(TreeNode& trTableTheme);
	///End NEW_QUICKFIT_ROI_XF_DLG
	bool applyPreferSettings(bool bCurrentTab);
	/// Iris 1/22/2010 COMMENT_OUT_UNUSEFUL_CODES
	//void saveThemeSettings(bool bCurrentTab, LPCSTR lpcszFunction = NULL, LPCSTR lpcszThemeFile = NULL);
	///End COMMENT_OUT_UNUSEFUL_CODES
	
	void setTabDirty(int nTab, bool bDirty = true);
	void checkEnableApply();
	
	void enableTablePreferCtrls();
	
	int getFuncParamList(vector<string>& vsParams);
	
	bool setErrorMsgShow(RECT rrTab, RECT& rrErrMsg); /// Iris 2/04/2010 CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG

	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	void	moveContrlsVertical(vector<int>& vnIDs, vector<int>& vnIDsBottomOnly, int nOffset);
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	
private:
	TabControl		m_tab;

	Button			m_btnOutputNone;
	Button			m_btnScript;
	Button			m_btnResultLog;
	/// Iris 1/20/2010 SUPPORT_OUTPUT_REPORT_TO_WKS
	Button			m_btnOutputToWks; 
	Edit			m_edOutputWksName;
	///End SUPPORT_OUTPUT_REPORT_TO_WKS
	ComboBox		m_comboSignDigits;
	Button			m_btnSameAsInput;
	Button			m_btnUniform;
	Button			m_btnSourceGraphSameScale;
	Button			m_btnNumPoints;	
	ComboBox		m_comboOutputFitCurveTo; /// Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO

	Button			m_checkAddTableToGraph;
	ComboBox		m_comboEquationFormat;
	ComboBox		m_comboParams;
	Button			m_checkShowError;			///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	Button			m_checkFunction;
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	//Button			m_checkInput;
	//Button			m_checkInputRangeIndex; /// Iris 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
	//Button			m_checkOutput;
	ComboBox		m_comboInput;
	ComboBox		m_comboInputRange;
	ComboBox		m_comboOutput;
	Button			m_chkAddLegendSymbols;
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
	Button			m_btnFitStatsRsqCod;
	Button			m_btnFitStatsAdjRsq;
	///Sophy 1/28/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	Button			m_btnFitStatsRSquare;
	Button			m_btnFitStatsCorrelation;
	///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	Button			m_btnFitStatsNumIter;
	Button			m_btnFitStatsFitStatus;
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
	Edit			m_edROILeftX;
	Edit			m_edROIRightX;
	///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	Button			m_checkXScaleFix;
	/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	/////------ Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE
	//Button			m_checkAutoXFrom;
	//Button			m_checkAutoXTo;
	/////------ End SUPPORT_AUTO_FOR_X_SCALE
	///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	Button			m_checkAddToolName;
	ComboBox		m_comboROISignDigits;
	Edit			m_edToolName;
	Button			m_checkCloneMainObj;	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	//Button			m_btnROITopNone;
	//Button			m_btnROITopChiSqr;
	//Button			m_btnROITopAdjRSqr;
	//Button			m_btnROITopParam;
	///// Kenny 02/04/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	//Button			m_btnROITopPearson;
	//Button			m_btnROITOPRSquare;
	///// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	Button			m_chkROITopChiSqr;
	Button			m_chkROITopAdjRSqr;
	Button			m_chkROITopPearson;
	Button			m_chkROITopRSquare;
	///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	ComboBox		m_comboParamIndex;
	DynaControl		m_ctrlROI;
	/// Iris 2/04/2010 CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG
	Button			m_btnErrMsg;
	string			m_strErrMsg;
	///End CHECK_DISPLAY_BOOK_SHEET_NAME_ERR_MSG
	///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	//DynaControl		m_ctrlROIParamList;
	GridCheckListCtrl*	m_pGridParamList;
	///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	Tree			m_trROI;	
	
	vector<bool>	m_vbTabDirty;
	
	bool			m_bROIUsed;
	int				m_nOrder;
	string			m_strFunction;
	
	TreeNode		m_trSettings;/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG	
	
	bool			m_bXPosChanged; ///Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB

	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	BOOL			m_bSharedControlMoved;
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
};

enum {
	OUTPUT_TO_NONE = 0,	
	OUTPUT_TO_SCRIPT_WND,
	OUTPUT_TO_RESULT_LOG,
	/// Hong 01/20/10 QA80-14832 QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS
	OUTPUT_TO_WORKSHEET,
	/// end QUICK_FIT_SUPPORT_OUTPUT_RESULTS_TO_WKS
};

//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
////////////////Table Reference Dialog////////////////////
//////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////
/// Iris 1/18/2010 NEW_QUICKFIT_ROI_XF_DLG
enum {
	XF_TREENODE_VAR_ID_BEGIN = 1,
	XF_TREENODE_VAR_ID_MODE = XF_TREENODE_VAR_ID_BEGIN, ///Iris 1/19/2010 ADD_QUICK_FIT_MODE
	XF_TREENODE_VAR_ID_FUNC,
	XF_TREENODE_VAR_ID_BUTTON,
	//XF_TREENODE_VAR_ID_OUTPUT,	
	XF_TREENODE_VAR_ID_TABLE,
	XF_TREENODE_VAR_ID_REPORT,
	XF_TREENODE_VAR_ID_FITCURVE,
	XF_TREENODE_VAR_ID_ROI,
	XF_TREENODE_VAR_ID_REPLACE, /// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
};
///End NEW_QUICKFIT_ROI_XF_DLG

///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
/////Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST
//enum
//{
	//ROI_TOP_SHOW_NONE,
	//ROI_TOP_SHOW_REDUCED_CHI_SQR,
	//ROI_TOP_SHOW_ADJ_R_SQR,
	///// Kenny 02/04/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
//#ifdef QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
	//ROI_TOP_SHOW_PEARSON_R,
	//ROI_TOP_SHOW_R_SQUARE,
//#endif // QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
	///// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
	//ROI_TOP_SHOW_PARAM,
	//ROI_TOP_SHOW_MAX			/// Kenny 02/04/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
//};
/////End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
enum
{
	ROI_TOP_SHOW_REDUCED_CHI_SQR	= 0x0001,
	ROI_TOP_SHOW_ADJ_R_SQR			= 0x0002,
	ROI_TOP_SHOW_PEARSON_R			= 0x0004,
	ROI_TOP_SHOW_R_SQUARE			= 0x0008,
};
///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX

///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
enum {
	PARAMETER_TABLE_NONE,
	PARAMETER_TABLE_ALL_PARAMS,
	PARAMETER_TABLE_FOLLOW_ROI_TAB
};
///End CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB


#define MAX_NUM_PARAMS		32		///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST, at most 32 parameters

enum
{
	//!!! CAN NOT change the order of the following entries, please always add as the last one.
	QUICK_FIT_MODE_ID = 50, // DataID of the xf variable all are 50(0x32)
	QUICK_FIT_FUNCTION_ID = 50, // 0x32
	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	//QUICK_FIT_REPLACE_LAST_OUTPUT_ID = 50, /// Iris 2/01/2010 USE_COMMON_REPLACE_CHECK
	///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	
	//************* Report *****************
	QUICK_FIT_OUTPUT_ID_BEGIN,
	QUICK_FIT_OUTPUT_TO = QUICK_FIT_OUTPUT_ID_BEGIN,
	QUICK_FIT_OUTPUT_WKS_NAME,
	QUICK_FIT_OUTPUT_ID_END = 199,
	
	//************* Output Choice *****************
	QUICK_FIT_OUTPUT_CHOICE_BEGIN = 200,
	QUICK_FIT_SIGNIFICANT_DIGITS = QUICK_FIT_OUTPUT_CHOICE_BEGIN,
	/// Iris 1/21/2010 CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	/*
	QUICK_FIT_EQUATION_ID,
	QUICK_FIT_EQUATION_FORMAT_ID,
	QUICK_FIT_VALUE_ID,
	QUICK_FIT_ERROR_ID,
	*/
	QUICK_FIT_OUTPUT_FUNCTION_ID,
	QUICK_FIT_OUTPUT_INPUT_ID,
	QUICK_FIT_OUTPUT_INPUT_RANGE_INDEX_ID, /// Iris 01/27/10 QA80-14832 OUTPUT_TO_WKS_NEED_LEGEND_STRING_AND_ROW_INDEX
	QUICK_FIT_OUTPUT_OUTPUT_ID,
	QUICK_FIT_OUTPUT_WEIGHTING_ID,
	QUICK_FIT_PARAMETER_ID,
	QUICK_FIT_SHOW_ERROR_ID,				///Kyle 01/27/2010 CHANGE_PARAMETER_TABLE_DESIGN_IN_TABLE_AND_REPORT_TAB
	QUICK_FIT_EQUATION_FORMAT_ID,
	///End CHANGE_FUNCTION_AND_PARAMETERS_GROUP_DESIGN
	QUICK_FIT_STATS_BRANCH_ID,	
	/// Hong 02/20/10 QA80-14832 IMPROVE_GUI_OF_INPUT_OUTPUT
	QUICK_FIT_OUTPUT_LEGEND_ID,
	/// end IMPROVE_GUI_OF_INPUT_OUTPUT
	QUICK_FIT_OUTPUT_CHOICE_END = 399, 
	
	//************* Fit Curve *****************
	QUICK_FIT_OUTPUT_FIT_CURVE_BEGIN = 400,
	QUICK_FIT_OUTPUT_FIT_CURVE_OPTION = QUICK_FIT_OUTPUT_FIT_CURVE_BEGIN,	
	//QUICK_FIT_OUTPUT_X_AUTO_FROM, /// Iris 1/19/2010 NEW_QUICKFIT_ROI_XF_DLG
	//QUICK_FIT_OUTPUT_X_FROM, /// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	//QUICK_FIT_OUTPUT_X_AUTO_TO, /// Iris 1/19/2010 NEW_QUICKFIT_ROI_XF_DLG
	//QUICK_FIT_OUTPUT_X_TO, /// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	QUICK_FIT_OUTPUT_NUM_POINTS,
	///------ Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	QUICK_FIT_OUTPUT_REPLACE_EXISTING_CURVE,
	///------ End ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
	QUICK_FIT_OUTPUT_FIT_CURVE_TO_ID, /// Iris 1/22/2010 ADD_CONTROL_TO_SPECIFY_FIT_CURVE_OUTPUT_TO
	QUICK_FIT_OUTPUT_FIT_CURVE_END = 599,
	
	//************* Table *****************
	QUICK_FIT_TABLE_ID_BEGIN = 600,
	QUICK_FIT_TABLE_ID = QUICK_FIT_TABLE_ID_BEGIN,
	/// Iris 12/30/2009 TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	/*
	QUICK_FIT_DATETIME_ID,
	QUICK_FIT_FUNC_NAME_ID,
	*/
	///End TEXT_BOX_ALWAYS_SHOW_MODEL_AND_DATETIME
	QUICK_FIT_TABLE_ID_END = 699,
	
	//************* ROI *****************
	QUICK_FIT_ROI_ID_BEGIN = 700,
	/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB 
	//QUICK_FIT_ROI_TOOL_NAME_ID = QUICK_FIT_ROI_ID_BEGIN,
	QUICK_FIT_ROI_LEFT_X = QUICK_FIT_ROI_ID_BEGIN,
	QUICK_FIT_ROI_RIGHT_X,
	QUICK_FIT_ROI_TOOL_NAME_ID,
	///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	QUICK_FIT_ROI_CENTER_TEXT_ID,
	///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST, at most 32 parameters
	//QUICK_FIT_ROI_PARAM_INDEX,
	QUICK_FIT_ROI_PARAM_BEGIN,
	QUICK_FIT_ROI_PARAM_END = QUICK_FIT_ROI_PARAM_BEGIN + MAX_NUM_PARAMS - 1,
	///End SHOW_ALL_PARAMETERS_AS_CHECK_LIST
	QUICK_FIT_ROI_RECT_COLOR_ID,
	QUICK_FIT_ROI_FITCURVE_COLOR_ID,
	/// Iris 1/15/2010 NEW_QUICKFIT_ROI_XF_DLG
	/*
	///------ Folger 01/14/09 QA81-14832 SUPPORT_QUICK_FIT_THEME_WITH_PREFERENCE_SETTINGS
	QUICK_FIT_FUNCTION,
	///------ End SUPPORT_QUICK_FIT_THEME_WITH_PREFERENCE_SETTINGS
	QUICK_FIT_ROI_ID_BEGIN = 600,
	*/
	///End NEW_QUICKFIT_ROI_XF_DLG
	QUICK_FIT_ROI_CLONE_MAINOBJ_ID,	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	QUICK_FIT_ROI_ID_END = 899,	
	
	/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
	/*
	//************* Branch *****************
	QUICK_FIT_OUTPUT_PREFER_BRANCH_ID = 10000,
	QUICK_FIT_TABLE_PREFER_BRANCH_ID,
	QUICK_FIT_ROI_PREFER_BRANCH_ID,
	*/
	///End REARRANGE_PREFERENCE_DLG_TABS
	
	//************* Stats *****************
	// keep the following ID same as in RegStats structure.	
	QUICK_FIT_REDUCED_CHISQ_ID = IDE_FIT_REDUCED_CHI_SQUARE, // 366
	QUICK_FIT_ADJR_ID = IDE_FIT_ADJ_RSQUARE, //356
};



struct	QuickFitResults
{
	bool			bIsApparentFit; /// Iris 2/04/2010 SHOW_APPARENT_FIT_IN_LABEL
	vector			vParams;
	vector			vErrors;
	vector<string>	vsParamNames;
	RegStats		stRegStats;
	string 			strWeighting;
	string 			strFitOutcome;	
	///------ Folger 04/09/10 QA81-15992 QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
	BOOL			bGoodFit;
	int				nNumIteration;
	int				nFitOutcome;
	///------ End QUICK_FIT_OUTPUT_REPORT_INCLUDE_NUMBER_ITERATION_AND_FIT_STATUS
};

enum
{
	NLSF_QUICKFIT_ERROR_INVALID_FUNCTION			= -100,
	NLSF_QUICKFIT_ERROR_INVALID_PARAMS,
	NLSF_QUICKFIT_ERROR_FAIL_TO_SET_FUNCTION,
	NLSF_QUICKFIT_ERROR_FAIL_TO_SET_DATA,
	NLSF_QUICKFIT_ERROR_FAIL_TO_INIT_PARAMS,
	NLSF_QUICKFIT_ERROR_FAIL_TO_GET_FIT_PARAM_NAMES,
	NLSF_QUICKFIT_ERROR_FAIL_TO_GET_FIT_PARAMS,
	NLSF_QUICKFIT_ERROR_FAIL_TO_GET_FIT_STATS,
	NLSF_QUICKFIT_ERROR_FAIL_EVALUATE_CURVE,

	NLSF_QUICKFIT_ERROR_NONE						= 0,
	NLSF_QUICKFIT_ERROR_FIT_NOT_CONVERGED,
};

class QuickFitFindXYDlg : public ResizeDialog
{
public:	
	QuickFitFindXYDlg();	
	int DoModalEx(HWND hWndParent = NULL);
	
protected:
	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_DESTROY(OnDestroy)		///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	/*
	ON_SIZE(OnDlgResize)
	ON_RESTORESIZE(OnRestoreSize)	
	*/
	ON_BN_CLICKED(IDC_BTN_FINDX, OnClickFindXButton)	
	ON_BN_CLICKED(IDC_BTN_FINDY, OnClickFindYButton)
	
	ON_BN_CLICKED(IDC_BTN_FINDX_OUTPUT, OnClickFindXOutputButton)	
	ON_BN_CLICKED(IDC_BTN_FINDY_OUTPUT, OnClickFindYOutputButton)

	///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	ON_BN_CLICKED(IDC_FINDXY_OUTPUT_TO_SCRIPT_WINDOW, OnClickFindXYOutputTo)
	ON_BN_CLICKED(IDC_FINDXY_OUTPUT_TO_RESULT_LOG, OnClickFindXYOutputTo)
	ON_BN_CLICKED(IDC_FINDXY_OUTPUT_TO_WORKSHEET, OnClickFindXYOutputTo)
	///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	
	///Sophy 1/18/2010 QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS
	ON_BN_CLICKED(IDC_BTN_FINDXY_OUTPUT, OnClickFindXYOutputButton)
	ON_BN_CLICKED(IDC_BTN_FINDXY, OnClickFindXYButton)
	ON_EN_CHANGE(IDC_FINDXY_X, OnXYValueChange)
	ON_EN_CHANGE(IDC_FINDXY_Y, OnXYValueChange)
	///end QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS

	///------ Folger 02/03/10 ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG
	ON_EN_CHANGE(IDC_FINDXY_WORKSHEET, OnOutputWorksheetChange)
	ON_BN_CLICKED(IDC_BTN_GO_TO_REPORT, OnClickGoToWorksheet)
	///------ End ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG

EVENTS_END

	BOOL OnInitDialog();
	BOOL OnDestroy();			///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	BOOL OnDlgResize(int nType, int cx, int cy);	
	BOOL OnRestoreSize(DWORD dwSizeInfo);	
	
	BOOL OnClickFindXButton(Control ctrl);
	BOOL OnClickFindYButton(Control ctrl);
	
	BOOL OnClickFindXOutputButton(Control ctrl);
	BOOL OnClickFindYOutputButton(Control ctrl);
	
	///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	BOOL OnClickFindXYOutputTo(Control ctrl);
	///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	
	///Sophy 1/18/2010 QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS
	BOOL OnClickFindXYOutputButton(Control ctrl);
	BOOL OnClickFindXYButton(Control ctrl);
	BOOL OnXYValueChange(Control ctrl);
	///end QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS

	///------ Folger 02/03/10 ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG
	BOOL	OnClickGoToWorksheet(Control ctrl);
	BOOL	OnOutputWorksheetChange(Control ctrl);
	///------ End ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG

private:
	bool getFindXYInput(bool bFindX, vector& vecToFind);
	bool findxy(bool bFindX, const vector& vecToFind);
	//bool outputToWks(bool bFindX);
	void displayFinding(bool bFindX);
	bool onClickFindButton(bool bFindX);
	
	bool onclickOutputButton(bool bFindX);
	int getOutputWindow();
	void outputFinding(bool bFindX);
	
	///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	void loadSettings();
	void saveSettings();
	/// Iris 1/23/2010 IMPROVE_FINDXY_OUTPUT_TO_WKS_CODES
	//Worksheet getOutPutWorksheet();
	void outputReportSheet(bool bFindX, LPCSTR lpcszInfo);
	///End IMPROVE_FINDXY_OUTPUT_TO_WKS_CODES
	///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	
	///Sophy 1/15/2010 QUICKFIT_SHOW_CURRENT_SELECTED_RANGE_ON_FINDXYDLG
	bool updateRangeInfo();
	///end QUICKFIT_SHOW_CURRENT_SELECTED_RANGE_ON_FINDXYDLG
	
	/// Iris 1/25/2010 FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL
	void setXColumnFormat(TreeNode& trN);
	void setYColumnFormat(TreeNode& trN, LPCSTR lpcszInfo);
	///End FINDXY_OUTPUT_WKS_NEED_KEEP_SAME_FORMAT_WITH_SOURCE_X_COL
	
	///------ Folger 02/03/10 ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG
	void	CheckEnableGoToWorksheet();
	///------ End ADD_GO_TO_REPORT_BUTTON_TO_FINDXY_DIALOG
	
private:
	GraphLayer			m_gl;
	DataPlot			m_dpSource;
	Worksheet			m_wks;
	
	/// Iris 2/05/2010 FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	//QuickFitResults		m_stFitResults;
	vector				m_vParamValues;
	int					m_i1;
	int					m_i2;
	///End FIX_SWITCH_TO_NLFIT_ALWAYS_USE_PARAM_INIT_VALUES
	string				m_strFunctionName;
	int					m_nOrder;
	
	//Tree				m_trOutput;	 //----- Iris 2/05/2010, no palce use m_trOutput, significant digits always use Origin default setting, so comment out.
	
	vector				m_vFindXYInput;
	vector				m_vFindXYOutput;
	vector<int>			m_vnFindingGroupIndex; // one Y can find multi Xs, this member data to separate x by y.
	
	Button				m_btnFindX;
	Button				m_btnFindY;
	Button				m_btnFindXOutput;
	Button				m_btnFindYOutput;
	///Sophy 1/18/2010 QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS
	Button				m_btnOutput;
	Button				m_btnFind;
	bool				m_bFindX;			
	///end QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS
	///Sophy 1/20/2010 QA80-14832 SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
	int					m_nXFormat;
	int					m_nXSubFormat;
	string				m_strCustomFmt;
	///end SUPPORT_FIND_X_AS_DATE_TIME_FORMAT
	///Kyle 01/11/2010 ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	//Button				m_edInY;
	//Button				m_edOutX;
	//Button				m_edInX;
	//Button				m_edOutY;
	Button				m_edX;
	Button				m_edY;
	
	Button				m_btnOutputScript;
	Button				m_btnOutputResultLog;	///Sophy 1/15/2010 QUICKFIT_ROI_FINDXYDLG_SUPPORT_OUTPUT_TO_RESULT_LOG
	Button				m_btnOutputWorksheet;
	Edit				m_edOutputWks;
	///End ONE_EDIT_BOX_FOR_X_AND_Y_VALUES_AND_DUMP_TO_WORKSHEET_SUPPORT
	
	Control				m_txtRangeHints;	///Sophy 1/15/2010 QUICKFIT_SHOW_CURRENT_SELECTED_RANGE_ON_FINDXYDLG
	
	bool				m_bHasDoFinding; /// Iris 1/25/2010 TO_FIX_CLICK_OUTPUT_BUTTON_ALWAYS_DO_FINDXY

};

void AddToolQuickFit(TreeNode& trGUI);
bool GetQuickFitToolSettings(TreeNode& trGUI);

enum
{
	NLSF_QUICKFIT_ROI_RESULT	= 0x00000001,
	NLSF_QUICKFIT_ROI_PREVIEW	= 0x00000002,
};

/// Iris 1/19/2010 ADD_QUICK_FIT_MODE
enum {
	QUICK_FIT_MODE_LR=0,
	QUICK_FIT_MODE_NL
};

enum
{
	FIT_CURVE_TYPE_SAME_AS_INPUT = 0,
	FIT_CURVE_TYPE_SAME_SOURCE_SCALE_TYPE,
	FIT_CURVE_TYPE_UNIFORM,
};

#define		QUICK_FIT_LR_MODE_FUNCS		0x0001
#define		QUICK_FIT_NL_MODE_FUNCS		0x0010
#define		QUICK_FIT_ALL_MODE_FUNCS		QUICK_FIT_LR_MODE_FUNCS | QUICK_FIT_NL_MODE_FUNCS
///End ADD_QUICK_FIT_MODE

int		nlsf_quick_fit(GraphLayer& gl, QuickFitResults& stFitResults, vector& vFitX, vector& vFitY, LPCSTR lpcszFuncName, int nOrder, const XYRange& iy, DWORD dwCntrl = 0);

///Sophy 1/12/2010 SHOW_LEGEND_IN_RESULT_TABLE
//bool 	quick_fit_output_report(GraphLayer& gl, const XYRange& iy, const QuickFitResults& stFitResults, LPCSTR lpcszFuncName, int nOrder, bool bFromApplyButton = false);
bool 	quick_fit_output_report(GraphLayer& gl, const XYRange& iy, const QuickFitResults& stFitResults, LPCSTR lpcszFuncName, int nOrder, bool bFromApplyButton = false, bool bFromROI = true, bool bReplaceLastOutput = false);
///end SHOW_LEGEND_IN_RESULT_TABLE

/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
/*
///------ Folger 01/12/09 QA81-14832 ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
bool	quick_fit_replace_existing_curve();
///------ End ADD_OPTION_TO_GENERATE_NEW_FIT_CURVE_FOR_EACH_OUTPUT
*/
///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU

/// Iris 1/15/2010 NEW_QUICKFIT_ROI_XF_DLG
bool 	quick_fit_get_preference_settings(TreeNode& tr, LPCSTR lpcszThemeFile = NULL);
///------ Folger 04/09/10 UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
//BOOL 	OpenQuickFitEditDlg(HWND hWndParent = NULL, int nMode = QUICK_FIT_MODE_NL);
BOOL 	OpenQuickFitEditDlg(HWND hWndParent = NULL, int nMode = QUICK_FIT_MODE_NL, string* pstrSelectedFunc = NULL);
///------ End UPDATE_LAST_SELECTED_FUNCTION_FROM_EDIT_FUNCTION_DIALOG_TO_QUICKFIT_ROI
/// Iris 1/19/2010 ADD_QUICK_FIT_MODE
//int		quick_fit_get_func_list(vector<string>& vsFuncs);
/// Iris 1/22/2010 KEEP_FIRST_3_POLY_FUNC_WITH_REAL_NAME
//int		quick_fit_get_func_list(vector<string>& vsFuncs, int nFuncMode = QUICK_FIT_ALL_MODE_FUNCS);
///Iris 1/26/2010 ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
//int		quick_fit_get_func_list(vector<string>& vsFuncs, int nFuncMode = QUICK_FIT_ALL_MODE_FUNCS, int nMaxOrder = NUM_POLY_FUNC_MAX_ORDER);
int		quick_fit_get_func_list(vector<string>& vsFuncs, int nFuncMode = QUICK_FIT_ALL_MODE_FUNCS, int* pnNumPolyFuncs = NULL);
///End ADD_TAB_IN_FUNC_EDIT_DLG_TO_SEP_LR_AND_NL_FUNCS
///End KEEP_FIRST_3_POLY_FUNC_WITH_REAL_NAME
///End ADD_QUICK_FIT_MODE
/// Iris 1/20/2010 REARRANGE_PREFERENCE_DLG_TABS
//void 	construct_quick_fit_output_refer_gui(TreeNode& tr);
void 	construct_quick_fit_report_refer_gui(TreeNode& tr);
void 	construct_quick_fit_curve_refer_gui(TreeNode& tr);
///End REARRANGE_PREFERENCE_DLG_TABS
void 	construct_quick_fit_table_prefer_gui(TreeNode& tr);
void 	construct_quick_fit_roi_refer_gui(TreeNode& tr);
string 	get_quick_fit_prefer_theme_file();
/// Iris 1/23/2010 FIX_DUPLICATION_DATAID
//void 	quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(TreeNode& tr, int* pBranchDataID);
void 	quick_fit_check_convert_data_id_based_on_xf_treenode_var_id(TreeNode& tr, int nBranchDataID);
///End FIX_DUPLICATION_DATAID
int 	quick_fit_get_order(int nFitMode, LPCSTR lpcszFunc);
///End NEW_QUICKFIT_ROI_XF_DLG

int quick_fit_get_func_param_list(vector<string>& vsParams, int nFitMode, LPCSTR lpcszFunc);		///Kyle 01/22/2010 SHOW_ALL_PARAMETERS_AS_CHECK_LIST

string 	quick_fit_get_lr_function_name(int nOrder, bool bAddPolyPostfix = false); /// Iris 1/21/2010 USE_NTH_ORDER_REPLACE_REAL_NAME_FOR_LR

bool quick_fit_get_rect_ROI_init_x_range(GraphLayer& gl, double& dLeftX, double& dRightX); /// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB

bool quick_fit_get_source_from_to(double* pdFrom, double* pdTo, int* pnNumPoints);

///Sophy 2/2/2010 SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT
bool quick_fit_update_output_choice_on_mode_change(TreeNode& trGetN, TreeNode trTable);
///end SMART_DIFF_STATS_BETWEEN_POLYFIT_AND_NLFIT

/// Kenny 02/04/2010 QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI
///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
//enum
//{
	//QFROI_UPDATESHOWTOP_SEL_KEEP_LAST_ONE	= -1,
	//QFROI_UPDATESHOWTOP_SEL_IGNORE			= -2,
//};
enum
{
	//QFROI_UPDATESHOWTOP_SEL_KEEP_LAST_ONE	= 0x0001,
	QFROI_UPDATESHOWTOP_SEL_IGNORE			= 0x0002,
};
///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX

#ifdef QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
	///---Sim 02-20-2010 QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
	//int		quick_fit_get_roi_show_top_enum(TreeNode& trShowTop);
	//bool	quick_fit_set_roi_show_top_enum(TreeNode& trShowTop, int nShowTop);
	DWORD		quick_fit_get_roi_show_top_enum(TreeNode& trShowTop);
	bool	quick_fit_set_roi_show_top_enum(TreeNode& trShowTop, DWORD dwShowTop);
	//bool	quick_fit_update_roi_show_top(TreeNode& trShowTop, TreeNode& trTable, int nSelRoiTop = QFROI_UPDATESHOWTOP_SEL_KEEP_LAST_ONE);
	bool	quick_fit_update_roi_show_top(TreeNode& trShowTop, TreeNode& trTable, DWORD dwCtrl = 0);
	///---END QA81-14832-P3 SUPPORT_MULTI_SEL_CHECKBOX_FOR_SHOW_TOP_ROI_BOX
#else
	#define	quick_fit_get_roi_show_top_enum(trShowTop)							trShowTop.nVal
	#define	quick_fit_set_roi_show_top_enum(trShowTop, nShowTop)				(trShowTop.nVal = nShowTop)
	#define	quick_fit_update_roi_show_top(trShowTop, trTable, nSelRoiTop)		true
#endif // QUICK_FIT_UPDATE_ROI_TOP_RELATED_GUI
/// End QA81-14832-P3 QUICK_FIT_IMPROVE_ROI_TOP_RELATED_GUI

///------ Folger 01/21/10 QA81-14903 QUICKFIT_SAVE_THEME_WITHOUT_ROI
#define	STR_NO_ROI_SPECIFIER		" Without ROI Box"
void	quick_fit_set_attributes(TreeNode& tr);

string&		quick_fit_current_theme();
class	QuickFitNoROIThemeSwtichHelper
{
public:
	QuickFitNoROIThemeSwtichHelper(LPCSTR lpcszTheme)
	{
		m_strTheme = quick_fit_current_theme();
		string&		str = quick_fit_current_theme();
		str = lpcszTheme;
	}
	~QuickFitNoROIThemeSwtichHelper()
	{
		string&		str = quick_fit_current_theme();
		str = m_strTheme;
	}

private:
	string		m_strTheme;
};
///------ End QUICKFIT_SAVE_THEME_WITHOUT_ROI

///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
void	quickfit_on_func_change(TreeNode& tr, WndContainer& DynaCntrlContainer);
void	quickfit_update_function_list(TreeNode& tr);
void	quickfit_update_on_mode_function_change(TreeNode& tr, int nSelRoiTop = -1);
///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU

/// Hong 02/20/10 QA80-14832 CENTRALIZE_CODE
bool	quickfit_get_source_dataplot(DataPlot& dp, GraphLayer& glSrc = NULL);
/// end CENTRALIZE_CODE

bool get_gl_quick_fit_rect_go_name(GraphLayer& gl, string& strRect);

// can change data by ROI context menu, so ROI known which plot is the current input data.
int quickf_fit_get_source_data_plot_index_from_ROI(GraphObject& go);

// if Fixed checkbox is checked, directly return false without change trROI, else retun true with the following changes.
//		1. if no ROI on graph, change trROI with good init x position;
//		2. if has ROI on graph, get the ROI position and update to trROI		
bool quick_fit_check_update_roi_x_position(TreeNode& trROI);

///Sophy 3/1/2010 UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI
string	get_output_range_str(int nOutputType);
///end UPDATE_SETTINGS_FROM_THEME_FILE_WHNE_NO_ROI

/// Kenny 03/04/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
int quickfit_get_fit_line_auto_color(int nDefaultColor = SYSCOLOR_BLUE, const DataPlot& srcDataPlot = NULL);
/// End QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR

#endif //_QUICK_FIT_H
